/*
 * clTogglingSequences.h
 *
 *  Created on: Nov 19, 2012
 *      Author: vo84hi
 */

#ifndef CLTOGGLINGSEQUENCES_H_
#define CLTOGGLINGSEQUENCES_H_

#include "InterfaceAudioStack.h"


//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
//#include <stl_pif.h>

#include <map>


#include "AudioStack/AudioSources.h"


namespace AudioStack
{

class AudioToggleGroups
{
public:
    typedef enum{
        NONE      = 0,
        AUX       = 1,
        RMT_CTRL  = 2,
        MFL_ORDER = 2,
        RADIO     = 3,
        CD        = 4,
        SD        = 5
    } enToggleGroup;
};

class clTogglingSequences {
public:

//   typedef enum {
//         toggleGroupNone  = 0,
//         toggleGroupRadio = 1,
//         toggleGroupCD    = 2,
//         toggleGroupSD    = 3,
//         toggleGroupAUX   = 4, //used for NISSAN only
//         toggleGroupEnd   = 5
//      } toggleGroup_t;

   /** Source toggle Sequence of Steering wheel remote control.
    *  Map key defines the actual Source, the Value
    *  defines the targeted Source that should be toggled to.
    */
   static std::map<AudioSources::enAudioSources,AudioSources::enAudioSources> ToggleSeq_RmtCtrl;

   /** Source toggle Sequence for AUX Group
    *  Map key defines the actual Source, the Value
    *  defines the targeted Source that should be toggled to.
    */
   static std::map<AudioSources::enAudioSources,AudioSources::enAudioSources> ToggleSeq_Aux;

   /** Source toggle Sequence for Radio Group
    *  Map key defines the actual Source, the Value
    *  defines the targeted Source that should be toggled to.
    */
   static std::map<AudioSources::enAudioSources,AudioSources::enAudioSources> ToggleSeq_Radio;

   /** Source toggle Sequence for CD Group
    *  Map key defines the actual Source, the Value
    *  defines the targeted Source that should be toggled to.
    */
   static std::map<AudioSources::enAudioSources,AudioSources::enAudioSources> ToggleSeq_CD;


//   static AudioSources::enAudioSources GetNextSource(AudioSources::enAudioSources source);
   static AudioSources::enAudioSources GetNextSourceClass(AudioSources::enAudioSources source, AudioToggleGroups::enToggleGroup toggleGroup);
//   static AudioSources::enAudioSources GetNextSource(AudioSources::enAudioSources source, AudioToggleGroups::enToggleGroup toggleGroup);
   static AudioToggleGroups::enToggleGroup FindToggleGroup(AudioSources::enAudioSources source);
   static inline tVoid vInitToggleSeq();
   static tVoid vInitToggleSeq_RmtCtrl();
   static tVoid vInitToggleSeq_Aux();
   static tVoid vInitToggleSeq_CD();
   static tVoid vInitToggleSeq_Radio();

   clTogglingSequences();
   virtual ~clTogglingSequences();
};

}//namespace

#endif /* CLTOGGLINGSEQUENCES_H_ */
